package cn.com.duiba.cloud.manage.service.api.remoteservice.system;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 员工管理remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-06 15:18
 * @since 2.0.8
 **/
@AdvancedFeignClient
public interface RemoteEmployeesService {
    /**
     * 同步钉钉企业员工
     *
     * @param operator 操作用户id
     * @throws BizException 业务异常
     */
    void syncDingTalkEmployees(@NotNull(message = "操作用户id不能为空") Long operator) throws BizException;

    /**
     * 根据部门id关联员工橘色
     *
     * @param deptId   部门id
     * @param roleIds  角色id列表
     * @param operator 操作者用户id
     * @return 布尔值
     * @throws BizException 业务异常
     */
    boolean associationRoleByDept(@NotNull(message = "部门id不能为空") Long deptId
            , @NotEmpty(message = "角色id列表不能为空") List<Long> roleIds
            , @NotNull(message = "操作用户id不能为空") Long operator) throws BizException;

    /**
     * 修改员工启用开关
     *
     * @param staffId      员工id
     * @param operator     操作者用户id
     * @param enableStatus 启用开光，是否启用
     * @return 布尔值
     */
    boolean enableStatusSwitch(@NotNull(message = "员工id不能为空") Long staffId
            , @NotNull(message = "操作用户id不能为空") Long operator
            , @NotNull(message = "启用状态不能为空") @Range(min = 0, max = 1, message = "启用状态有误") Integer enableStatus);
}
