package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description redis key
 * @date 2021/11/8 11:20
 */
public enum RedisKeyEnum {

    /**
     *
     */
    PREFIX("前缀", "ZHONGYAN_MANAGE_SERVICE:"),

    /**
     * 企业相关
     */
    FIRST_LOGIN("首次登录", "DUIBA_MANAGE_SERVICE:FIRST_LOGIN"),
    CAPTCHA("图片验证码", "DUIBA_MANAGE_SERVICE:CAPTCHA"),
    LAST_LOGIN("上次登录", "DUIBA_MANAGE_SERVICE:LAST_LOGIN"),
    TENANT_STAFF_REL("企业内员工关系", "DUIBA_MANAGE_SERVICE:TENANT_STAFF_REL:{}_{}"),

    /* 角色相关 */

    UNIQUE_TENANT_ROLE_NAME("企业下角色名称唯一", "DUIBA_MANAGE_SERVICE:TB_ROLE:{}_{}"),
    UNIQUE_TENANT_NAME("企业名称唯一", "DUIBA_MANAGE_SERVICE:TB_TENANT:{}"),
    UNIQUE_DEPT_NAME("部门名称唯一", "DUIBA_MANAGE_SERVICE:TB_DEPT:{}"),

    /* 信息相关*/
    SYNC_MATERIAL("同步微信素材","DUIBA_MANAGE_SERVICE:SYNC_MATERIAL:{}"),
    COUNT_TAG_VALUE_USER("计算标签值关联人数","DUIBA_MANAGE_SERVICE: COUNT_TAG_VALUE_USER"),
    COUNT_TAG_GROUP_USER("计算标签用户群关联人数","COUNT_TAG_GROUP_USER"),

    PUBLISH_PAGE("发布页面","DUIBA_MANAGE_SERVICE:PUBLISH_PAGE:{}"),

    /*es同步相关*/
    ES_CLEAR_TEMPLETE("删除es索引","DUIBA_MANAGE_SERVICE:CLEAR_TEMPLETE:{}"),
    ES_PAGE_STATISTICS("页面数据统计","DUIBA_MANAGE_SERVICE:PAGE_STATISTICS:{}"),
    ES_UNIT_STATISTICS("组件数据统计","DUIBA_MANAGE_SERVICE:UNIT_STATISTICS:{}"),

    RETAILER_ENTER_JOB("同步零售户入网锁", "DUIBA_MANAGE_SERVICE:RETAILER_ENTER_JOB"),
    /**
     * 锁相关
     */
    LOCK_ALI_TAG("阿里云标签定时任务同步锁", "ZHONGYAN_MANAGE_SERVICE:ALI_TAG"),
    LOCK_ALI_OPENID("阿里云零售户、消费者标签值清单定时任务同步锁", "ZHONGYAN_MANAGE_SERVICE:LOCK_ALI_OPENID"),


    /** 个人信息相关 */
    CONSUMER_INFO_CHANGE_SORT("修改个人信息顺序", "ZHONGYAN_MANAGE_SERVICE:CONSUMER_INFO_CHANGE_SORT"),
    CONSUMER_INFO_SAVE("保存个人信息", "ZHONGYAN_MANAGE_SERVICE:CONSUMER_INFO_SAVE:{}"),


    /**
     * 新版本的key，使用 {@link RedisKeyEnum#getKey}，会自动补充项目前缀
     */
    CREATE_ACTIVITY("创建模板活动", "CREATE_ACTIVITY:{}", "用户id"),
    LOCK_TERMINAL_AUDIT("管理员审核终端业务员上报情况锁", "TERMINAL_AUDIT:{}:{}", "活动id参数", "用户id参数"),
    LOCK_THREE_DAY_ACQUIRE_CUSTOMER("三日无获客定时任务锁", "THREE_DAY_ACQUIRE_CUSTOMER"),

    CREATE_TERMINAL_STAFF("创建终端业务员", "createTerminalStaff_{}", "终端业务员编号"),

    ALL_GEO_CACHE("行政区划地址", "allGeoCache"),

    /**
     * 心中的远方活动相关
     */
    PEACE_REMAIN_REPORT("计算平和星余额","DUIBA_MANAGE_SERVICE:PEACE_REMAIN_REPORT_KEY"),

    USER_VIEW_REPORT("时段独立访客数","DUIBA_MANAGE_SERVICE:USER_VIEW_REPORT_KEY"),

    /**
     * 心中的远方活动专属
     */
    ACTIVITY_JOIN_STATISTICS_KEY("活动参与报表","DUIBA_ACTIVITY_JOIN_STATISTICS_KEY:{}_{}"),
    ACTIVITY_TASK_STATISTICS_KEY("活动任务报表","DUIBA_ACTIVITY_TASK_STATISTICS_KEY:{}_{}"),
    ACTIVITY_TODAY_ASS_STATISTICS_KEY("活动当天10，16点数据统计","DUIBA_ ACTIVITY_TODAY_ASS_STATISTICS_PRE_KEY:{}_{}"),
    ACTIVITY_PRIZE_STATISTICS_KEY("活动奖品报表","DUIBA_ACTIVITY_PRIZE_STATISTICS_KEY:{}_{}"),


    /**
     * 旅行活动
     */
    TRAVEL_RETENTION_REPORT("计算留存率","DUIBA_MANAGE_SERVICE:TRAVEL_RETENTION_REPORT_KEY"),
    TRAVEL_POINT_REPORT("计算平和星余额", "DUIBA_MANAGE_SERVICE:TRAVEL_POINT_REPORT_KEY"),
    ACTIVITY_PLAN_TEMPLATE_KEY("活动计划版块", "DUIBA_MANAGE_SERVICE:ACTIVITY_PLAN_TEMPLATE_KEY"),
    ACTIVITY_PLAN_TEMPLATE_REMOVE_KEY("活动计划版块移动","DUIBA_MANAGE_SERVICE:ACTIVITY_PLAN_TEMPLATE_REMOVE_KEY"),
    ACTIVITY_PLAN_CHANGE_STATUS("活动计划进度流转", "DUIBA_MANAGE_SERVICE:ACTIVITY_PLAN_CHANGE_STATUS"),

    ACTIVITY_USER_VIEW_REPORT("时段独立访客数","DUIBA_MANAGE_SERVICE:USER_VIEW_REPORT_KEY:{}_{}"),

    DISPLAY_DETAIL_JOB("陈列竞赛明细","DUIBA_MANAGE_SERVICE:DISPLAY_DETAIL_JOB"),
    VERIFY_LOCK("陈列竞赛审核","DUIBA_MANAGE_SERVICE:DISPLAY_VERIFY"),

    OPERATE_PLAN_LOCK("运营计划锁","DUIBA_MANAGE_SERVICE:OPERATE_PLAN:{}"),
;

    private final String desc;
    private final String template;

    private final String[] argsDesc;


    RedisKeyEnum(String desc, String template, String...argsDesc) {
        this.desc = desc;
        this.template = template;
        this.argsDesc = argsDesc;
    }

    @Deprecated
    public static String getRedisKey(RedisKeyEnum keyTemplate, Object... args) {
        return StrUtil.format(keyTemplate.template, args);
    }

    public static String getKey(RedisKeyEnum keyTemplate, Object... args) throws BizException {
        // 校验参数数量是否正确
        int count = StrUtil.count(keyTemplate.template, "{}");
        Conditions.expectTrue(ObjectUtil.equals(count, args.length), "参数数量缺失");
        return StrUtil.format(RedisKeyEnum.PREFIX.template + keyTemplate.template, args);
    }
}
