package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/5 14:10
 **/
@Getter
@Setter
public class RemoteSuppliesDistributeQueryParam implements Serializable {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 零售户id list（会按500条，分多次查询聚合结果）
     */
    @NotEmpty(message = "零售户id列表不能为空")
    private List<Long> retailerIdList;
}
