package cn.com.duiba.cloud.manage.service.api.model.param.terminal;


import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 14:00
 */
@Getter
@Setter
public class RemoteTerminalEditParam extends BaseParam {

    /**
     * id
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 终端业务员姓名
     */
    @NotBlank(message = "终端业务员姓名不能为空")
    @Size(max = 30, message = "终端业务员名称不可超过30个字符")
    private String name;

    /**
     * 终端业务员手机号
     */
    @NotBlank(message = "终端业务员手机号不能为空")
    @Pattern(regexp = RegexpConst.PHONE, message = "仅限输入11位国内手机号")
    private String phone;

    /**
     * 地区code
     */
    @NotEmpty(message = "地区code不能为空")
    private List<String> addressCode;
}
