package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.ReceiveConditionDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteReceiveConditionQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteReceiveConditionSaveParam;

import java.util.List;

/**
 * 消费者领取礼品情况表服务接口
 *
 * @author yuanzhixin
 * @since 2022-07-09 15:07:13
 * @description
 */
@AdvancedFeignClient
public interface RemoteReceiveConditionService {

    /**
     * 保存消费者领取情况
     * @param param 参数
     */
    void save(RemoteReceiveConditionSaveParam param);

    /**
     * 根据参数查询消费者领取情况
     * @param param 查询参数
     * @return List<ReceiveConditionDTO>
     */
    List<ReceiveConditionDTO> queryByParam(RemoteReceiveConditionQueryParam param);
}
