package cn.com.duiba.cloud.manage.service.api.model.enums.system;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 员工账号是否离职状态枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-07 14:48
 * @since 2.0.8
 **/
@Getter
@AllArgsConstructor
public enum AccountStateEnum implements IEnum<Integer> {
    /**
     * 已离职
     */
    HAVE_LEFT(0, "已离职"),

    /**
     * 正常
     */
    NORMAL(1, "正常"),
    ;

    /**
     * 离职状态值
     */
    private Integer dbCode;

    /**
     * 离职状态文本
     */
    private String text;
}
