package cn.com.duiba.cloud.manage.service.api.remoteservice.report;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.ActivityReplayDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.DateStatisticTag;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.PhwdDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.RetailerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.TagDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.TobaccoReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.WechatFansDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.WechatPageReadDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.export.ExportReportResultDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.report.ActivityReplayParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.DeleteActivityParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.ExportReportParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.ReportParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.SaveActivityParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.TagReportParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.UpdateActivityReplayParam;
import cn.com.duiba.cloud.manage.service.api.utils.UploadResult;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;
import java.util.List;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
@SuppressWarnings("all")
public interface RemoteReportService {

    /**
     * 平和味道报表
     *
     * @param param 参数
     * @return 分页数据
     */
    PageResponse<PhwdDTO> queryPhwd(ReportParam param);

    /**
     * 零售户入网2021.5.31版
     *
     * @param param 参数
     * @return 分页数据
     */
    PageResponse<RetailerDTO> queryRetailer(ReportParam param);

    /**
     * 公众号粉丝变化
     *
     * @param param
     * @return
     */
    PageResponse<WechatFansDTO> queryWechatFans(ReportParam param);

    /**
     * 公众号阅读量
     *
     * @param param
     * @return
     */
    PageResponse<WechatPageReadDTO> queryWechatPageRead(ReportParam param);

    /**
     * 公众号阅读量 合计
     * @param  param
     * @return
     */
    WechatPageReadDTO querySumWechatPageRead(ReportParam param);


    /**
     * 卷烟扫码量
     *
     * @param param
     * @return
     */
    PageResponse<TobaccoReportDTO> queryTobacco(ReportParam param);


    /**
     * 标签统计
     *
     * @param param
     * @return
     */
    PageResponse<TagDTO> queryTag(PageRequest param);

    /**
     * 根据日期统计标签数据
     * @param param
     * @return
     */
    PageResponse<DateStatisticTag> queryDateTag(TagReportParam param);

    /**
     * 运营复盘
     *
     * @param param 参数
     * @return
     */
    PageResponse<ActivityReplayDTO> queryActivityReplay(ActivityReplayParam param);

    /**
     * 保存运营复牌
     *
     * @param param 参数
     * @return id
     */
    Long saveActivityReplay(SaveActivityParam param);

    /**
     * 删除运营复牌
     *
     * @param param 参数
     * @return boolean
     */
    Boolean deleteActivityReplay(DeleteActivityParam param);

    /**
     * 更新运营复牌
     *
     * @param param 参数
     * @return boolean
     */
    Boolean updateActivityReplay(UpdateActivityReplayParam param);

    /**
     * 导出没有运营复盘
     *
     * @param reportParam
     * @return
     */
    ExportReportResultDTO exportReportWithOutReplay(ExportReportParam reportParam) throws BizException;

    /**
     * 导出有运营复盘
     *
     * @param activityReplayParam
     * @return
     */
    ExportReportResultDTO exportReport(ExportReportParam activityReplayParam) throws BizException;


}
