package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class ActivityReplayExportData implements Serializable {
    @ExcelProperty("序号")
    private Long id;
    /**
     * 活动ID
     */
    @ExcelProperty("活动名称")
    private String activityName;
    /**
     * 活动版块归属
     */
    @ExcelProperty("36个活动版块归属")
    private String activityBelong;
    /**
     * 活动开始结束时间
     */
    @ExcelProperty("活动时间")
    private String startEndTime;
    /**
     * 需求来源
     */
    @ExcelProperty("需求来源")
    private String demandSource;
    /**
     * 零售户入网户数（万户）
     */
    @ExcelProperty("零售户入网户数（万户）")
    private Long retailerUser;
    /**
     * 公众号关注量 万
     */
    @ExcelProperty("公众号关注量（万人）")
    private Long wechatFollowUser;

    /**
     * 零售户活动交互（万户次）
     */
    @ExcelProperty("零售户活动交互（万户次）")
    private Long retailerActivityPv;
    /**
     * 消费者活动交互（万人次）
     */
    @ExcelProperty("消费者活动交互（万人次）")
    private Long consumerActivityPv;
    /**
     * 推文宣传交互阅读量（万人次）
     */
    @ExcelProperty("推文宣传交互阅")
    private Long wechatReadPv;
}
