package cn.com.duiba.cloud.manage.service.api.remoteservice.activityReport;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.ActivityReportDataDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.PeaceRemainReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.UserViewReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.signActivity.JoinReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.signActivity.PrizeReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.signActivity.TaskReportDTO;

import java.util.List;

/**
 * @author zht
 * @Date 2022/7/18
 */
@AdvancedFeignClient
public interface RemoteDataActivityReportService {


    /**
     * 参与报表
     * @param activityId
     * @return
     */
    JoinReportDTO getJoinReport(Long activityId);

    /**
     * 任务报表
     * @param activityId
     * @return
     */
    TaskReportDTO getTaskReport(Long activityId);

    /**
     * 奖品报表
     * @param activityId
     * @return
     */

    PrizeReportDTO getPrizeReport(Long activityId);

    /**
     * 平和星余额报表
     * @param activityId 活动id
     * @return
     */
    PeaceRemainReportDTO peaceRemainReport(Long activityId);

    /**
     * 用户时段访问记录报表
     * @param activityId 活动id
     * @return
     */
    UserViewReportDTO userView(Long activityId);

    /**
     * 根据活动id查询
     * @param activityId 活动id
     * @param reportType 报表类型
     * @param dataType 报表数据类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.report.ReportDataTypeEnum
     * @return 活动下的所有数据
     */
    List<ActivityReportDataDTO> queryReportDataByActivityIdAndType(Long activityId, Integer reportType,Integer dataType);


    void  testSomeTask(Integer num) throws BizException;

    void testPeaceRemainReport(String day,Integer hour) throws Exception;
    void testUserViewReport(String day,Integer hour) throws Exception;



}
