package cn.com.duiba.cloud.manage.service.api.remoteservice.upcoming;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.TweetsPlanDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteQueryTweetsPlanParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteTweetsPlanParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author xuanyu
 * @description:
 * @date 2022/11/18 2:51 PM
 */
@AdvancedFeignClient
public interface RemoteTweetsPlanService {

    /**
     * 查询推文计划
     * @param remoteQueryTweetsPlanParam
     * @return
     */
    PageResponse<TweetsPlanDTO> listTweetsPlan(RemoteQueryTweetsPlanParam remoteQueryTweetsPlanParam);

    /**
     * 编辑推文计划
     * @param remoteTweetsPlanParam
     */
    void editTweetsPlan(RemoteTweetsPlanParam remoteTweetsPlanParam) throws BizException;

    /**
     * 删除推文计划
     * @param tweetsPlanId
     */
    void deleteTweetsPlan(Long tweetsPlanId) throws BizException;

    /**
     * 查询推文计划详情
     * @param tweetsPlanId
     * @return
     */
    TweetsPlanDTO getTweetsPlanDetail(Long tweetsPlanId);
}
