package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.ActivityReachDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.ActivityShuffleDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.OperatingPlanDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.RateOfSurfaceDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.TweetShuffleDTO;

import java.util.List;

/**
 * datav，一品一策remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-30 16:49
 * @since 3.0.2
 **/
@AdvancedFeignClient
public interface RemoteProductPlanService {
    /**
     * 活动触达数据
     *
     * @return 活动触达数据
     */
    ActivityReachDTO getActivityReachData();

    /**
     * 活动轮播数据
     *
     * @return 活动轮播数据
     */
    List<ActivityShuffleDTO> getActivityShuffleData();

    /**
     * 两面两率
     *
     * @return 两面两率
     */
    RateOfSurfaceDTO getRateOfSurface();

    /**
     * 运营计划
     *
     * @return 运营计划数据
     */
    List<OperatingPlanDTO> getOperatingPlan();

    /**
     * 推文轮播
     *
     * @return 推文轮播数据
     */
    List<TweetShuffleDTO> getTweetShuffle();
}
