package cn.com.duiba.cloud.manage.service.api.remoteservice.staff;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.QueryRoleStaffIdsDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.StaffOwnRoleDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.StaffRoleDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteQueryRoleStaffIdsParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteRoleAddStaffParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteRoleDeleteStaffParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteStaffOwnRoleParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteStaffRoleQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 角色员工远程服务
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/8
 */
@AdvancedFeignClient
public interface RemoteStaffRoleService {

    /**
     * 角色下员工分页查询
     * @param queryParam
     * @return
     * @throws BizException
     */
    public PageResponse<StaffRoleDTO> staffRoleQuery(RemoteStaffRoleQueryParam queryParam) throws BizException;

    /**
     * 为角色添加员工
     *
     * @param addStaffParam
     * @throws BizException
     */
    public void roleAddStaff(RemoteRoleAddStaffParam addStaffParam) throws BizException;

    /**
     * 为角色删除员工
     *
     * @param deleteStaffParam
     * @throws BizException
     */
    public void roleDeleteStaff(RemoteRoleDeleteStaffParam deleteStaffParam) throws BizException;

    /**
     * 查询员工下的角色
     *
     * @param ownParam
     * @return
     * @throws BizException
     */
    public StaffOwnRoleDTO staffOwnRole(RemoteStaffOwnRoleParam ownParam) throws BizException;

    /**
     * 查询角色的员工id列表
     * @param param
     * @return
     * @throws BizException
     */
    public QueryRoleStaffIdsDTO queryRoleStaffIds(RemoteQueryRoleStaffIdsParam param) throws BizException;

}
