package cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 推文轮播
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-10-08 17:44
 * @since 3.0.2
 **/
@Data
@Accessors(chain = true)
public class TweetShuffleDTO implements Serializable {
    private static final long serialVersionUID = 2293961886447023954L;

    /**
     * 推文名称
     */
    private String tweetName;

    /**
     * 推文图片
     */
    private String tweetImage;

    /**
     * 发布时间
     */
    private Date releaseTime;

    /**
     * 内容概要
     */
    private String contentOutline;

    /**
     * 阅读量
     */
    private String readingNumber;

    /**
     * 评论数
     */
    private String commentNumber;

    /**
     * 精选评论
     */
    private List<String> selectComment;
}
