package cn.com.duiba.cloud.manage.service.api.model.enums.importdata;

import java.util.Objects;

/**
 * @author linzhou
 * @ClassName ImportDataTypeEnum.java
 * @createTime 2021年11月03日 19:40:00
 * @Description
 */
public enum ImportDataTypeEnum {

    /**
     *
     */
    STAFF_INVITE((byte)1,"员工邀请导入"),
    ROLE_STAFF_INVITE((byte)2,"角色员工导入"),
    TAG_VALUE_USER((byte)3,"标签值关联用户"),
    DELI_GOODS_IMPORT((byte)4,"得力商品导入"),
    SUNING_GOODS_IMPORT((byte)5,"苏宁商品导入"),

    TAG_CANCEL_USER((byte)9,"标签值关联用户"),
    BLACK_GRAY_IMPORT((byte)6,"黑灰名单导入"),
    TERMINAL_STAFF_IMPORT((byte) 7, "终端业务员导入"),
    ACTIVITY_DATA_IMPORT((byte) 8, "活动数据导入"),
    MANAGE_YEAR_PLAN_IMPORT((byte) 10, "年度计划倒入"),

    RISK_IMPORT((byte) 11,"风控历史数据导入"),

    CHEAT_REMOVE((byte) 12,"移除防作弊名单"),

    AREA_IMPORT((byte)13, "导入市场"),
    OPERATIONAL_IMPORT((byte)14, "导入活动营销计划"),

    TWEET_IMPORT((byte)15, "导入推文宣传计划"),
    ;

    /**
     *
     */
    private Byte type;
    /**
     * 描述
     */
    private String desc;

    ImportDataTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ImportDataTypeEnum getImportDataTypeEnum(Byte type) {
        for (ImportDataTypeEnum value : ImportDataTypeEnum.values()) {
            if (Objects.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
