package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/5 14:31
 **/
@Getter
@Setter
public class RemoteAwardQueryParam implements Serializable {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 终端业务员id
     */
    @NotNull(message = "终端业务员id不能为空")
    private Long terminalId;

    /**
     * 零售户id list（会按500条，分多次查询聚合结果）
     */
    private List<Long> retailerIdList;
}
