package cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan;

import lombok.Data;

import java.io.Serializable;

/**
 * 活动触达DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-30 17:08
 * @since 3.0.2
 **/
@Data
public class ActivityReachDTO implements Serializable {
    private static final long serialVersionUID = 6288901337868473261L;

    /**
     * 零售户触达数
     */
    private Long retailerReachCount;

    /**
     * 零售户平均参与数
     */
    private Double retailerAverageJoinCount;

    /**
     * 消费者触达数
     */
    private Long consumerReachCount;

    /**
     * 消费者平均参与数
     */
    private Double consumerAverageJoinCount;

    /**
     * 消费调研参与人数
     */
    private Long consumeResearchJoinCount;

    /**
     * 品鉴开展次数
     */
    private Long tasteCarryOutNumber;

    /**
     * 品鉴覆盖人数
     */
    private Long tasteCoverageCount;

    /**
     * 扫码上柜参与零售户数
     */
    private Long scanWhichRetailerJoinCount;

    /**
     * 扫码上柜参与消费者数
     */
    private Long scanWhichConsumerJoinCount;
}
