package cn.com.duiba.cloud.manage.service.api.model.dto.plan;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author zht
 * @Date 2022/9/16
 */
@Data
public class RemoteMotherPlanDto implements Serializable {
    /**
     * 计划id
     */
    private Long id;
    /**
     * 活动版块
     */
    private String templateName;
    /**
     * 运营项目id
     */
    private Long templateId;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动开始时间
     */
    private Date startTime;
    /**
     * 活动结束时间
     */
    private Date endTime;
    /**
     * 活动品规
     */
    private List<String> regulateList;
    /**
     * 部门
     */
    private List<String> departmentList;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 负责人
     */
    private List<RemoteDutyPersonDto> dutyPersonVoList;

    private Long sort;

    /**
     * 待办存在和完成状态
     */
    private Map<String,Integer> upComingStatusMap;

    /**
     * 活动方案
     */
    private String releaseApproval;

    /**
     * 物资审批
     */
    private String materialApproval;

    /**
     * 活动开发
     */
    private String eventDevelopment;

    /**
     * 推文
     */
    private String tweets;

    /**
     * 活动发布
     */
    private String eventRelease;

    /**
     * 直播
     */
    private String liveStreaming;
    /**
     * 模板消息
     */
    private String templateMessage;
}
