package cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 审批单导出信息
 * @Date 2022/11/9 13:55
 * @Author LuHui
 */
@Data
public class RemoteApprovalSheetExportDto implements Serializable {
    private static final long serialVersionUID = 2045469888594870559L;

    /**
     * 审批单id
     */
    private Long id;
    /**
     * 审批单名字
     */
    private String approvalSheetName;
    /**
     * 所属类型
     */
    private String approvalType;
    /**
     * 发起时间 毫秒级时间戳
     */
    private Date gmtCreate;
    /**
     * 审批单状态 1:待发起 2:审批中 3:审批通过 4:审批失败
     */
    private String status;
    /**
     * 完成时间 毫秒级时间戳
     */
    private Date completeTime;
    /**
     * 用户名称
     */
    private String username;
    /**
     * 部门名称
     */
    private String departmentName;

}
