package cn.com.duiba.cloud.manage.service.api.model.dto.staff;

import cn.com.duiba.cloud.manage.service.api.model.dto.dept.DeptStaffDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.system.AccountTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author linzhou
 * @ClassName StaffListVo.java
 * @createTime 2021年11月02日 11:33:00
 * @Description
 */
@Getter
@Setter
public class StaffDetailDTO implements Serializable {

    private Long id;

    /**
     * 内部用户id
     */
    private Long innerUserId;

    /**
     * 员工名称
     */
    private String staffName;
    /**
     * 人员手机号码
     */
    private String mobile;
    /**
     * 员工编号
     */
    private String userId;
    /**
     * 岗位名称
     */
    private String positionName;
    /**
     * 角色
     */
    private String roleNames;
    private List<Long> roleIds;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 备注
     */
    private String remark;

    /**
     * 员工账号类型
     *
     * @see AccountTypeEnum
     */
    private Integer accountType;

    private List<DeptStaffDTO> deptStaffDTOS;
}
