package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.cloud.manage.service.api.model.enums.exportrecord.ExportDataTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @author zht
 * @Date 2022/8/29
 */
@Getter
@AllArgsConstructor
@NoArgsConstructor
public enum ExportUserTypeEnum {

    CONSUMER_TYPE(1,"消费者"),
    ZERO_USER_TYPE(2,"零售户"),
    ALL_TYPE(3,"-");


    private Integer type;

    private String desc;


    public static String getExportUserDesc(Integer type){
        for (ExportUserTypeEnum value : ExportUserTypeEnum.values()) {
            if (Objects.equals(value.getType(),type)){
                return value.getDesc();
            }
        }
        return ALL_TYPE.getDesc();
    }

}
