package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description 审批单状态
 * @Date 2022/11/7 16:06
 * @Author LuHui
 */
public enum ApprovalSheetStatusEnum {
    WAIT_CREATE(1, "待发起"),
    APPROVAL(2, "审批中"),
    PASS(3, "审批通过"),
    FAIL(4, "审批失败"),

    ;

    private Integer code;
    private String desc;

    ApprovalSheetStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ApprovalSheetStatusEnum getByType(Integer type){
        if (Objects.isNull(type)){
            return null;
        }
        return Stream.of(ApprovalSheetStatusEnum.values()).filter(x -> Objects.equals(x.getCode(), type)).findFirst().orElse(null);
    }
}
