package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author: LuHui
 * @Date: 2022/10/26 19:13
 * @Description:
 */
public enum PlanProcessEnum {
    CREATE(1, 0, "计划创建"),
    CLOSE(1, 6, "计划创建"),
    CONFIRM(2, 1, "计划确认"),
    PREPARING(3, 2, "计划筹备"),
    PREPARE(3, 3, "计划筹备"),
    START(4,4, "计划进行"),
    END(4, 7, "计划进行"),
    COMPLETE(5, 5, "计划完成"),

    ;

    private Integer id;
    /**
     * 状态 0:待确认 1:已确认 2:筹备中 3:筹备完成 4:进行中 5:已结束 6:已关闭 7:活动结束
     * @See cn.com.duiba.cloud.manage.service.api.model.enums.plan.PlanStatusEnum
     */
    private Integer status;

    private String desc;

    PlanProcessEnum(Integer id, Integer status, String desc) {
        this.id = id;
        this.status = status;
        this.desc = desc;
    }

    public Integer getId() {
        return id;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static PlanProcessEnum queryEnumByStatus(Integer status) throws BizException {
        return Stream.of(PlanProcessEnum.values()).filter(x -> Objects.equals(x.getStatus(), status)).findFirst()
                .orElseThrow(() -> new BizException(ErrorCode.ERROR_PARAM.getMsg()).withCode(ErrorCode.ERROR_PARAM.getCode()));
    }
}
