package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 苏宁自订单参数
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningOrderItemParam implements Serializable {

    private static final long serialVersionUID = -8151813020117382800L;
    /**
     * 订单行号
     */
    @NotBlank(message = "订单行号不能为空")
    private String orderItemId;

    /**
     * 商品编号
     */
    @NotBlank(message = "商品编号不能为空")
    private String skuId;

}
