package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import cn.com.duiba.cloud.manage.service.api.annotation.EnumValid;
import cn.com.duiba.cloud.manage.service.api.model.enums.AssociateStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.EnableStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.PageBaseParam;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 11:32
 */
@Getter
@Setter
public class RemoteTerminalStaffPageParam extends PageBaseParam {

    /**
     * 编号
     */
    private String num;

    /**
     * 终端业务员姓名
     */
    private String name;

    /**
     * 终端业务员手机号
     */
    private String phone;

    /**
     * 微信昵称
     */
    private String nickname;

    /**
     * 地区code
     */
    private List<String> addressCode;

    /**
     * 启用状态 {@link EnableStateEnum}
     */
    @EnumValid(target = EnableStateEnum.class, message = "启用状态不合法")
    private Integer state;

    /**
     * 关联状态 {@link AssociateStateEnum}
     */
    @EnumValid(target = AssociateStateEnum.class, message = "关联状态不合法")
    private Integer associateState;
}
