package cn.com.duiba.cloud.manage.service.api.model.param.user;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdatePasswordParam implements Serializable {

    private static final long serialVersionUID = -9205945061694730824L;

    @NotNull(message = "老密码不能为空")
    @Pattern(regexp = RegexpConst.PASSWORD, message = "旧密码格式不正确")
    @DataSecretFiledAnnotation
    private String oldPassword;

    @Pattern(regexp = RegexpConst.PASSWORD, message = "新密码密码格式不正确")
    @DataSecretFiledAnnotation
    private String newPassword;

    @NotNull(message = "员工编号不能为空")
    private String userId;
}
