package cn.com.duiba.cloud.manage.service.api.remoteservice.flexible;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.flexible.CanSelectFieldDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.flexible.CanSelectFlexibleTableDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.flexible.FlexibleDataListDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.flexible.FlexibleReportConfigDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.flexible.SingleFlexibleConfigDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.flexible.RemoteCreateFlexibleParam;
import cn.com.duiba.cloud.manage.service.api.model.param.flexible.RemoteListFlexibleDataParam;
import cn.com.duiba.cloud.manage.service.api.model.param.flexible.RemoteListFlexibleReportConfigParam;
import cn.com.duiba.cloud.manage.service.api.model.param.flexible.RemoteUpdateFlexibleParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;
import java.util.Map;

/**
 * @author xuanyu
 * @description:
 * @date 2022/10/26 4:52 PM
 */
@AdvancedFeignClient
public interface RemoteFlexibleReportService {
    /**
     * 新增灵活报表配置
     * @param remoteCreateFlexibleParam
     * @return
     */
    Long createFlexibleReport(RemoteCreateFlexibleParam remoteCreateFlexibleParam) throws BizException;

    /**
     * 查询灵活报表配置
     * @param remoteListFlexibleReportConfigParam
     * @return
     */
    PageResponse<FlexibleReportConfigDTO> listFlexibleReportConfig(RemoteListFlexibleReportConfigParam remoteListFlexibleReportConfigParam);

    /**
     * 查询灵活配置报表数据
     * @param remoteListFlexibleDataParam
     * @return
     */
    FlexibleDataListDTO listFlexibleReportData(RemoteListFlexibleDataParam remoteListFlexibleDataParam) throws BizException;

    /**
     * 根据id查询灵活报表配置信息
     * @param reportConfigId 灵活报表配置id
     * @return
     */
    SingleFlexibleConfigDTO getFlexibleReportById(Long reportConfigId) throws BizException;

    /**
     * 删除灵活报表配置
     * @param reportConfigId
     */
    void deleteFlexibleReportConfig(Long reportConfigId);

    /**
     * 更新灵活报表
     * @param remoteUpdateFlexibleParam
     */
    void updateFlexibleReportConfig(RemoteUpdateFlexibleParam remoteUpdateFlexibleParam) throws BizException;

    /**
     * 可选择的灵活报表
     * @return
     */
    List<CanSelectFlexibleTableDTO> listCanSelectFlexibleTable();

    /**
     * 获取所有表的表字段配置信息
     * @return key:表别名 value:表字段信息
     */
    Map<String,List<CanSelectFieldDTO>> listCanSelectFlexibleField();
}
