package cn.com.duiba.cloud.manage.service.api.remoteservice.report;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.AreaDistributionDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.ProvinceConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.ProvinceRetailerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.RegionConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.RegionRetailerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.export.ExportReportResultDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.report.AreaDistributionExportParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.AreaDistributionQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.BusinessReportParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.UpdateTargetParam;
import cn.com.duiba.wolf.entity.PageResponse;
import java.util.List;

/**
 * 业务方报表
 *
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteBusinessReportService {

    /**
     * 业务方报表 浙江省内数据 零售入网
     *
     * @param param 参数
     * @return 任务ID
     */
    ExportReportResultDTO provinceReport(BusinessReportParam param) throws BizException;

    /**
     * 业务方报表 大区数据 零售入网
     *
     * @param param 参数
     * @return 任务ID
     */
    ExportReportResultDTO regionReport(BusinessReportParam param) throws BizException;

    /**
     * 业务方报表 浙江省内数据 消费者
     *
     * @param param 参数
     * @return 任务ID
     */
    ExportReportResultDTO consumerProvinceReport(BusinessReportParam param) throws BizException;


    /**
     * 业务方报表 大区数据 消费者
     *
     * @param param 参数
     * @return 任务ID
     */
    ExportReportResultDTO consumerRegionReport(BusinessReportParam param) throws BizException;


    /**
     * 业务方 浙江省内数据 零售入网
     *
     * @param param 参数
     * @return 省份数据
     */
    ProvinceRetailerDTO provinceQuery(BusinessReportParam param) throws BizException;

    /**
     * 业务方 大区数据 零售入网
     *
     * @param param 参数
     * @return 任务ID
     */
    List<RegionRetailerDTO> regionQuery(BusinessReportParam param) throws BizException;


    /**
     * 业务方报表 浙江省内数据 消费者
     *
     * @param param 参数
     * @return 任务ID
     *
     */
    ProvinceConsumerDTO consumerProvinceQuery(BusinessReportParam param) throws BizException;


    /**
     * 业务方报表 大区数据 消费者
     *
     * @param param 参数
     * @return 任务ID
     */
    List<RegionConsumerDTO> consumerRegionQuery(BusinessReportParam param) throws BizException;

    /**
     * 更新
     *
     * @param param 更新参数
     * @return 操作结果
     */
    Boolean updateTarget(UpdateTargetParam param);

    /**
     * 地域分布报表
     *
     * @param param 参数
     * @return 任务ID
     */
    ExportReportResultDTO areaDistributionReport(AreaDistributionExportParam param);

    /**
     * 地域分布查询
     * @param param 参数
     * @return 地域分布
     */
    PageResponse<AreaDistributionDTO> areaDistribution(AreaDistributionQueryParam param);
}
