package cn.com.duiba.cloud.manage.service.api.utils;

/**
 * @author xuanyu
 * @description: 二进制操作工具类
 * @date 2022/11/21 10:54 AM
 */
public class BinaryUtil {
    /**
     * 获取第index是0还是1
     *
     * @param num   64位数
     * @param index 位置
     * @return 0第index为0, 1第index位为1
     */
    public static Long getNumberOfBinaryBit(Long num, Integer index) {
        return (num >> (index - 1)) & 1;
    }

    /**
     * 将第index位置为1
     *
     * @param num       64位数
     * @param index     第index位
     * @param zeroOrOne 0或1
     * @return 新的64位数
     */
    public static Long setBinaryBit(Long num, Integer index, Integer zeroOrOne) {
        if (zeroOrOne == 1) {
            return (1L << (index - 1)) | num;
        } else {
            return ~(1L << (index - 1)) & num;
        }
    }
}
