package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Date 2022/11/9 15:09
 * @Author LuHui
 */
@Data
public class ExportApprovalSheetData implements Serializable {
    private static final long serialVersionUID = 4146624320859249255L;

    /**
     * 审批单id
     */
    @ExcelProperty("审批单编号")
    private Long id;
    /**
     * 审批单名字
     */
    @ExcelProperty("审批单名称")
    private String approvalSheetName;
    /**
     * 所属类型
     */
    @ExcelProperty("所属类型")
    private String approvalType;
    /**
     * 发起时间 毫秒级时间戳
     */
    @ExcelProperty("发起时间")
    private Date gmtCreate;
    /**
     * 审批单状态 1:待发起 2:审批中 3:审批通过 4:审批失败
     */
    @ExcelProperty("审批单状态")
    private String status;
    /**
     * 完成时间 毫秒级时间戳
     */
    @ExcelProperty("完成时间")
    private Date completeTime;
    /**
     * 用户名称
     */
    @ExcelProperty("发起人")
    private String username;
    /**
     * 部门名称
     */
    @ExcelProperty("发起人所在部门")
    private String departmentName;
}
