package cn.com.duiba.cloud.manage.service.api.model.dto.risk;

import lombok.Data;

import java.io.Serializable;

/**
 * @author: LuHui
 * @date: 2023/6/30 15:00
 * @description:
 */
@Data
public class RiskDetailDto implements Serializable {
    private static final long serialVersionUID = 4261349201042331316L;
    /**
     * id
     */
    private Long id;

    /**
     * 用户id
     */
    private String userId;

    /**
     * openId
     */
    private String openId;

    /**
     * 游戏次数
     */
    private Integer gameTimes;

    /**
     * 邀请助力次数
     */
    private Integer inviteAssistTimes;

    /**
     * 抽奖次数
     */
    private Integer drawTimes;

    /**
     * 获奖次数
     */
    private Integer acquirePrizeTimes;

    /**
     * 签到次数
     */
    private Integer signTimes;

    /**
     * 参与活动次数
     */
    private Integer joinActivityTimes;

    /**
     * 每日参与次数
     */
    private Integer dayJoinTimes;

    /**
     * 绑定收获地址数量
     */
    private Integer bindAddressNum;

    /**
     * 绑定收获人个数
     */
    private Integer bindTakePrizePersonNum;

    /**
     * 绑定手机号个数
     */
    private Integer bindPhoneNum;

    /**
     * 同时兑奖用户数
     */
    private Integer sameTimeTakePrizeUserNum;

    /**
     * 空间收获地址风险等级
     */
    private Integer spaceAddressRiskLevel;

    /**
     * 文本收获地址风险等级
     */
    private Integer textAddressRiskLevel;

    /**
     * PC模型得分
     */
    private String pcModelScore;

    /**
     * 随机森林模型得分
     */
    private String randomForestModelScore;

    /**
     * SVM模型得分
     */
    private String svmModelScore;

    /**
     * XGBoost模型得分
     */
    private String xgBoostModelScore;

    /**
     * Isolation Forest模型得分
     */
    private String isolationForestModelScore;

    /**
     * 游戏次数(仅统计因子)得分
     */
    private String gameTimesStatisticScore;

    /**
     * 邀请助力次数(仅统计因子)得分
     */
    private String inviteAssistTimesStatisticScore;

    /**
     * 抽奖次数(仅统计因子)得分
     */
    private String drawTimesStatisticScore;

    /**
     * 获奖次数(仅统计因子)得分
     */
    private String acquirePrizeTimesStatisticScore;

    /**
     * 签到次数(仅统计因子)得分
     */
    private String signTimesStatisticScore;

    /**
     * 参与活动数(仅统计因子)得分
     */
    private String joinActivityTimesStatisticScore;

    /**
     * 每日参与次数(仅统计因子)得分
     */
    private String dayJoinTimesStatisticScore;

    /**
     * 绑定收获地址数量(仅统计因子)得分
     */
    private String bindAddressNumStatisticScore;

    /**
     * 绑定收获人个数(仅统计因子)得分
     */
    private String bindTakePrizePersonNumStatisticScore;

    /**
     * 绑定手机号个数(仅统计因子)得分
     */
    private String bindPhoneNumStatisticScore;

    /**
     * 同时兑奖用户数(仅统计因子)得分
     */
    private String sameTimeTakePrizeUserNumStatisticScore;

    /**
     * TOPSIS(仅统计因子)得分
     */
    private String topSisStatisticScore;

    /**
     * 文本收获地址风险等级(仅高级因子)得分
     */
    private String textAddressRiskLevelHighScore;

    /**
     * 空间收获地址风险等级(仅高级因子)得分
     */
    private String spaceAddressRiskLevelHighScore;

    /**
     * TOPSIS(仅高级因子)得分
     */
    private String topSisHighScore;

    /**
     * 游戏次数(全部因子)得分
     */
    private String gameTimesAllScore;

    /**
     * 邀请助力次数(全部因子)得分
     */
    private String inviteAssistTimesAllScore;

    /**
     * 抽奖次数(全部因子)得分
     */
    private String drawTimesAllScore;

    /**
     * 获奖次数(全部因子)得分
     */
    private String acquirePrizeTimesAllScore;

    /**
     * 签到次数(全部因子)得分
     */
    private String signTimesAllScore;

    /**
     * 参与活动数(全部因子)得分
     */
    private String joinActivityTimesAllScore;

    /**
     * 每日参与次数(全部因子)得分
     */
    private String dayJoinTimesAllScore;

    /**
     * 绑定收获地址数量(全部因子)得分
     */
    private String bindAddressNumAllScore;

    /**
     * 绑定收货人个数(全部因子)得分
     */
    private String bindTakePrizePersonNumAllScore;

    /**
     * 绑定手机号个数(全部因子)得分
     */
    private String bindPhoneNumAllScore;

    /**
     * 同时兑奖用户数(全部因子)得分
     */
    private String sameTimeTakePrizeUserNumAllScore;

    /**
     * 空间收货地址风险等级(全部因子)得分
     */
    private String spaceAddressRiskLevelAllScore;

    /**
     * 文本收货地址风险等级(全部因子)得分
     */
    private String textAddressRiskLevelAllScore;

    /**
     * TOPSIS(全部因子)得分
     */
    private String topSisAllScore;

    /**
     * 总风险得分
     */
    private String totalRiskScore;


}
