/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.cloud.manage.service.api.utils.ImportExcelListener;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImportExcelHelper<T> {
    private static final Logger log = LoggerFactory.getLogger(ImportExcelHelper.class);

    public List<T> getList(MultipartFile file, Class<T> clazz, Integer sheetNo, Integer headRowNumber) {
        ImportExcelListener listener = new ImportExcelListener(headRowNumber);
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            try {
                ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), (Class)clazz, (ReadListener)listener).extraRead(CellExtraTypeEnum.MERGE).sheet(sheetNo).headRowNumber(headRowNumber)).doRead();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            latch.countDown();
        }).start();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        List<CellExtra> extraMergeInfoList = listener.getExtraMergeInfoList();
        if (this.isEmpty(extraMergeInfoList)) {
            return listener.getData();
        }
        CountDownLatch computerLatch = new CountDownLatch(1);
        AtomicReference data = new AtomicReference();
        new Thread(() -> {
            data.set(this.explainMergeData(listener.getData(), extraMergeInfoList, headRowNumber));
            computerLatch.countDown();
        }).start();
        try {
            computerLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (List)data.get();
    }

    private List<T> explainMergeData(List<T> data, List<CellExtra> extraMergeInfoList, Integer headRowNumber) {
        extraMergeInfoList.forEach(cellExtra -> {
            int firstRowIndex = cellExtra.getFirstRowIndex() - headRowNumber;
            int lastRowIndex = cellExtra.getLastRowIndex() - headRowNumber;
            int firstColumnIndex = cellExtra.getFirstColumnIndex();
            int lastColumnIndex = cellExtra.getLastColumnIndex();
            Object initValue = this.getInitValueFromList(firstRowIndex, firstColumnIndex, data);
            for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                for (int j = firstColumnIndex; j <= lastColumnIndex; ++j) {
                    this.setInitValueToList(initValue, i, j, data);
                }
            }
        });
        return data;
    }

    private void setInitValueToList(Object filedValue, Integer rowIndex, Integer columnIndex, List<T> data) {
        T object = data.get(rowIndex);
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            ExcelProperty annotation = field.getAnnotation(ExcelProperty.class);
            if (annotation == null || annotation.index() != columnIndex.intValue()) continue;
            try {
                field.set(object, filedValue);
                break;
            }
            catch (IllegalAccessException e) {
                log.error("\u8bbe\u7f6e\u5408\u5e76\u5355\u5143\u683c\u7684\u503c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    private Object getInitValueFromList(Integer firstRowIndex, Integer firstColumnIndex, List<T> data) {
        Object filedValue = null;
        T object = data.get(firstRowIndex);
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            ExcelProperty annotation = field.getAnnotation(ExcelProperty.class);
            if (annotation == null || annotation.index() != firstColumnIndex.intValue()) continue;
            try {
                filedValue = field.get(object);
                break;
            }
            catch (IllegalAccessException e) {
                log.error("\u8bbe\u7f6e\u5408\u5e76\u5355\u5143\u683c\u7684\u521d\u59cb\u503c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
        return filedValue;
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

