package cn.com.duiba.cloud.manage.service.api.remoteservice.supplier;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.SupplierAddressMappingDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteAddressMappingParam;

/**
 * 通用供应商服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/17
 */
@AdvancedFeignClient
public interface RemoteGeneralSupplierService {

    /**
     * 供应商地址匹配
     *
     * @param remoteParam 参数
     * @return 返回
     * @throws BizException 当某一级地址无法匹配时，会返回异常
     */
    public SupplierAddressMappingDTO supplierAddressMapping(RemoteAddressMappingParam remoteParam) throws BizException;

}
