package cn.com.duiba.cloud.manage.service.api.model.dto.plan;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description
 * @Date 2022/9/14 15:21
 * @Author LuHui
 */
@Data
public class RemoteYearPlanStatisticsDto implements Serializable {
    private static final long serialVersionUID = 4854805083932909354L;
    /**
     * 部门ID
     */
    private Integer departmentId;
    /**
     * 部门名称
     */
    private String department;
    /**
     * 零售户入网数
     */
    private Long saleAccessNum;
    /**
     * 消费者获客
     */
    private Long consumerAcquireNum;
    /**
     * 零售户活动交互
     */
    private Long saleJoinNum;
    /**
     * 消费者活动交互
     */
    private Long consumerJoinNum;
    /**
     * 推文宣传交互
     */
    private Long tweetJoinNum;
    /**
     * 策划推广费用
     */
    private Long planExtendCost;
    /**
     * 市场营销烟合计(万元)
     */
    private Long marketCigarettesCost;
    /**
     * 市场营销烟合计(条)
     */
    private Long marketCigarettesTotal;
    /**
     * 营销物资合计
     */
    private Long marketGoodNum;
    /**
     * 快递合计(单数)
     */
    private Long expressTotal;
    /**
     * 快递合计(万元)
     */
    private Long expressCost;
    /**
     * 零售户交互人均单价
     */
    private String saleJoinAvg;
    /**
     * 消费者交互人均单价
     */
    private String consumerJoinAvg;
    /**
     * 推文交互人均单价
     */
    private String tweetJoinAvg;
}
