package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description
 * @Date 2022/9/9 17:29
 * @Author LuHui
 */
public enum DepartmentEnum {
    BUSINESS_ONE(0, "业务一部"),
    BUSINESS_TWO(1, "业务二部"),
    BRAND(2, "品牌运营部"),
    ;


    private Integer code;

    private String desc;

    DepartmentEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DepartmentEnum getDepartmentById(Integer id){
        return Stream.of(DepartmentEnum.values()).filter(x -> Objects.equals(id, x.getCode())).findFirst().orElse(null);
    }
}
