package cn.com.duiba.cloud.manage.service.api.remoteservice.plan;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.RemoteEsPlanDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.RemotePlanDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.RemoteYearPlanPageDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.RemoteYearPlanStatisticsDto;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemoteDateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemoteYearPlanQueryParam;

import java.util.List;

/**
 * @Description
 * @Date 2022/9/13 17:34
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemotePlanService {

    /**
     * 保存数据
     *
     * @param list
     */
     void batchSaveDataToEs(List<RemoteEsPlanDto> list);

    /**
     * 批量更新数据
     *
     * @param list
     */
    void batchUpdateDataToEs(List<RemoteEsPlanDto> list);

    /**
     * 批量删除
     * @param list
     */
    void batchDeleteDataToEs(List<RemoteEsPlanDto> list);

    /**
     * 创建计划
     * @param remotePlanDto
     * @return
     * @throws BizException
     */
    Long create(RemotePlanDto remotePlanDto) throws BizException;

    /**
     *编辑计划
     * @param remotePlanDto
     * @return
     * @throws BizException
     */
    Boolean edit(RemotePlanDto remotePlanDto) throws BizException;

    /**
     * 删除计划
     * @param id
     * @return
     * @throws BizException
     */
    Boolean delete(Long id) throws BizException;

    /**
     * 计划详情
     * @param id
     * @return
     * @throws BizException
     */
    RemotePlanDto selectById(Long id) throws BizException;

    /**
     * 面板统计
     * @param param
     * @return
     */
    List<RemoteYearPlanStatisticsDto> queryStatistics(RemoteDateParam param) throws Exception;

    /**
     * 条件查询年度计划
     * @param param
     * @return
     */
    List<RemoteYearPlanPageDto> pageListYearPlan(RemoteYearPlanQueryParam param);
}
