package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 苏宁商品信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningSkuParam implements Serializable {

    private static final long serialVersionUID = -7968368049622523981L;

    /**
     * 购买数量 必填
     */
    @NotBlank(message = "请填写购买数量")
    private String num;

    /**
     * skuId 必填
     */
    @NotBlank(message = "请填写sku")
    private String skuId;

    /**
     * 商品单价 必填
     */
    @NotBlank(message = "请填写商品单价")
    private String unitPrice;

}
