package cn.com.duiba.cloud.manage.service.api.model.param.report;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdateTargetParam implements Serializable {

    private static final long serialVersionUID = 1984913166318827808L;

    @NotNull(message = "区域名称不能为空")
    private String regionName;

    /**
     * 目标关注量
     */
    private Long followingCountTarget;

    /**
     * 目标新增量
     */
    private Long followingIncreaseCountTarget;

    /**
     * 当年目标-户数剔除取关注
     */
    private Long userCountNotFollowingTarget;
    /**
     * 当年目标-新增户数剔除取关注
     */
    private Long userIncreaseCountNotFollowingTarget;

    /**
     * 统计日期
     */
    @NotNull(message = "日期不能为空")
    private Date date;

}
