package cn.com.duiba.cloud.manage.service.api.remoteservice.supplier;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.SuningCreateOrderDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.SuningLogisticsDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.SuningOrderStatusDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteSuningConfirmOrderParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteSuningCreateOrderParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteSuningGetOrderStatusParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteSuningLogisticsInfoParam;

/**
 * 苏宁供应商接口
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@AdvancedFeignClient
public interface RemoteSuningSupplierService {

    /**
     * 采购订单提交
     *
     * @param remoteParam 入参
     * @return 返回
     * @throws BizException 业务异常
     */
    SuningCreateOrderDTO createOrder(RemoteSuningCreateOrderParam remoteParam) throws BizException;

    /**
     * 查询订单状态 - 如果查无此订单会返回null
     *
     * @param remoteParam 入参
     * @return 返回
     * @throws BizException 业务异常
     */
    SuningOrderStatusDTO getOrderStatus(RemoteSuningGetOrderStatusParam remoteParam) throws BizException;

    /**
     * 确认收货
     *
     * @param remoteParam 入参
     * @return 返回
     * @throws BizException 异常
     */
    Boolean confirmOrder(RemoteSuningConfirmOrderParam remoteParam) throws BizException;

    /**
     * 查询物流信息
     *
     * @param remoteParam 入参
     * @throws BizException 异常
     */
    SuningLogisticsDTO getLogisticsInfo(RemoteSuningLogisticsInfoParam remoteParam) throws BizException;

}
