package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * 群发任务类型
 *
 * @author xuanhongjian
 */
@Getter
public enum GroupSendTaskTypeEnum {

    /**
     * 任务类型
     */
    MAIN_TASK(1, "主任务"),
    SUB_TASK(2, "子任务");

    private static final ImmutableMap<Integer, GroupSendTaskTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, GroupSendTaskTypeEnum> builder = ImmutableMap.builder();
        for (GroupSendTaskTypeEnum item : GroupSendTaskTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }


    private final Integer code;
    private final String desc;

    GroupSendTaskTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static GroupSendTaskTypeEnum getByCode(Integer termValue) {
        return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
    }

}
