 package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

 /**
  * 群发任务类型
  *
  * @author xuanhongjian
  */
 @Getter
 public enum GroupSendTypeEnum {

     /**
      * 1:立即群发，2：定时群发
      */
     IMMEDIATELY(1, "立即群发"),
     TIMING(2, "定时群发");

     private static final ImmutableMap<Integer, GroupSendTypeEnum> INNER_MAP;

     static {
         ImmutableMap.Builder<Integer, GroupSendTypeEnum> builder = ImmutableMap.builder();
         for (GroupSendTypeEnum item : GroupSendTypeEnum.values()) {
             builder = builder.put(item.code, item);
         }
         INNER_MAP = builder.build();
     }


     private final Integer code;
     private final String desc;

     GroupSendTypeEnum(Integer code, String desc) {
         this.code = code;
         this.desc = desc;
     }


     public static GroupSendTypeEnum getByCode(Integer termValue) {
         return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
     }

 }
