package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Objects;

/**
 * @author xuanhongjian
 */
@Getter
public enum PushScenesEnum {
    /**
     * 推送场景
     */
    PRIZE_NOTICE("活动中奖通知", 1),
    EXPIRED_NOTICE("过期提醒", 2),
    SHIP_NOTICE("发货提醒", 3),
    TIMING("手动推送",4),
    SALE_USER_CHECK_PASS("入网审核通过",5),
    SALE_USER_CHECK_UN_PASS("入网审核不通过",6),
    SALE_USER_APPEAL_PASS("专卖证申诉通过",7),
    SALE_USER_APPEAL_UN_PASS("专卖证申诉不通过",8),
    SALE_USER_MOBILE_CHECK("手机号被申诉",9),
    SALE_CERTIFICATE_NO_UN_BAND("专卖证被解绑",10),

    TERMINAL_AUDIT_PASS("获客活动-审核通过(业务员)", 11),
    TERMINAL_AUDIT_NOT_PASS("获客活动-审核不通过(业务员)", 12),
    RETAILER_JOIN_ACT("获客活动参与通知(零售户)", 13),
    RETAILER_CAN_RECEIVE("获客活动-零售户可领取奖品", 14),
    ;

    private final String desc;
    private final Integer code;

    PushScenesEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    private static final ImmutableMap<Integer, PushScenesEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, PushScenesEnum> builder = ImmutableMap.builder();
        for (PushScenesEnum item : PushScenesEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    public static PushScenesEnum getByCode(Integer termValue) {
        return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
    }
}
