package cn.com.duiba.wechat.server.api.enums;

import lombok.Getter;

/**
 * 操作记录状态
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/27 3:50 下午
 **/
@Getter
public enum OptRecordStatusEnum {
    /**
     * 成功
     */
    SUCCESS(1, "成功"),
    FAIL(2, "失败");

    private Integer value;

    private String desc;

    OptRecordStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OptRecordStatusEnum item : OptRecordStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OptRecordStatusEnum valueOf(Integer value) {
        for (OptRecordStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
