package cn.com.duiba.wechat.server.api.enums;

import lombok.Getter;

/**
 * 操作记录类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/27 3:50 下午
 **/
@Getter
public enum OptRecordTypeEnum {
    /**
     * 微信菜单发布
     */
    WX_MENU_PUBLISH(1, "微信菜单发布"),
    ;

    private Integer value;

    private String desc;

    OptRecordTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OptRecordTypeEnum item : OptRecordTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OptRecordTypeEnum valueOf(Integer value) {
        for (OptRecordTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
