package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.dto.qrcode.WechatQrcodeExtraDTO;
import cn.com.duiba.wechat.server.api.enums.LogoTypeEnum;
import cn.com.duiba.wechat.server.api.enums.QrCodeTypeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/7 18:14
 */
@Getter
@Setter
public class RemoteWechatCreateQrcodeParam implements Serializable {

    /**
     * 场景名称
     */
    @NotBlank(message = "请输入场景名称")
    private String name;

    /**
     * 微信二维码类型, 0 临时码，1 永久码，默认 0
     *
     * @see QrCodeTypeEnum
     */
    @NotNull(message = "微信二维码类型不能为空")
    private Integer type;

    /**
     * 有效期，单位小时 (永久码传-1)
     */
    @NotNull(message = "请输入有效期")
    @Max(value = 720, message = "临时码有效期最大不能超过720个小时")
    private Integer validTime;

    /**
     * logo url
     */
    private String logo;

    /**
     * logo类型, 0 无logo, 1 使用公众号头像, 2 自定义图片，默认 0
     *
     * @see LogoTypeEnum
     */
    private Integer logoType = 0;

    /**
     * 是否开启扫码粉丝打标， 默认false
     */
    private Boolean mark;

    /**
     * 是否开启扫码后自动回复， 默认false
     */
    private Boolean autoResp;

    /**
     * 扩展信息，包含打标 list, 回复内容list
     * @see WechatQrcodeExtraDTO
     */
    private WechatQrcodeExtraDTO extra;
}
