package cn.com.duiba.wechat.server.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;

import java.util.Date;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/11 10:01
 */
public class WxQrcodeUtil {

    /**
     * 最大时间跨度(单位天)
     */
    private static final Integer MAX_DAY_LIMIT = 31;

    /**
     * 校验时间跨度是否超过指定天数
     * @param start 开始时间
     * @param end 结束时间
     * @throws BizException 校验异常
     */
    public static void checkTimeRange(Date start, Date end) throws BizException {
        checkTimeRange(start, end, MAX_DAY_LIMIT);
    }

    /**
     * 获取时间区间
     * @param start 开始时间
     * @param end 结束时间
     * @param dateField 单位
     * @return List<DateTime>
     */
    public static List<DateTime> getDateTimeList(Date start, Date end, DateField dateField) {
        return DateUtil.rangeToList(start, end, dateField);
    }

    /**
     * 校验时间跨度是否超过指定天数
     * @param start 开始时间
     * @param end 结束时间
     * @param limit 指定天数
     * @throws BizException 校验异常
     */
    public static void checkTimeRange(Date start, Date end, int limit) throws BizException {
        Conditions.expectTrue(end.after(start), "结束时间需要大于开始时间");

        long rangeDay = DateUtil.between(end, start, DateUnit.DAY);
        Conditions.expectTrue(rangeDay <= limit, "时间范围不能超过" + limit + "天");
    }
}
