package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * @author xuanhongjian
 */

@Getter
public enum GroupSendStatueEnum {
    /**
     * 群发任务状态
     */
    TO_BE_STARTED(1, "待开始"),
    CANCELLED(2, "已取消"),
    TASK_FAILED(3, "任务失败"),
    IN_PROGRESS(4, "进行中"),
    WAIT_CALL_BACK(5,"等待微信回调完成"),
    FINISH(6, "任务完成");
    private static final ImmutableMap<Integer, GroupSendStatueEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, GroupSendStatueEnum> builder = ImmutableMap.builder();
        for (GroupSendStatueEnum item : GroupSendStatueEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    GroupSendStatueEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static GroupSendStatueEnum getByCode(Integer termValue) {
        return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
    }

}
