package cn.com.duiba.wechat.server.api.constant.enums;


import java.util.HashMap;
import java.util.Map;

/**
 * @author zouweixiang
 * @date 2021/11/26
 */
public enum WxPushMsgTypeEnum {
    /**
     * 推送消息类型
     */
    TEXT("text", "文本消息"),
    IMAGE("image", "图片消息"),
    IMG("img", "图片"),
    VOICE("voice", "语音消息"),
    VIDEO("video", "视频消息"),
    SHORTVIDEO("shortvideo", "小视频消息"),
    LOCATION("location", "地理位置消息"),
    LINK("link", "链接消息"),
    NEWS("news", "图文消息"),
    EVENT("event", "事件");

    private String msgType;

    private String desc;

    WxPushMsgTypeEnum(String msgType, String desc) {
        this.msgType = msgType;
        this.desc = desc;
    }

    private static final Map<String, WxPushMsgTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WxPushMsgTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getMsgType(), tmp);
        }
    }

    public static WxPushMsgTypeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public String getMsgType() {
        return msgType;
    }
    public String getDesc() {
        return desc;
    }
}
