package cn.com.duiba.wechat.server.api.dto.groupsendtask;

import cn.com.duiba.wechat.server.api.constant.enums.MaterialTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GroupSendTaskDTO implements Serializable {

    private static final long serialVersionUID = 8391102356778544450L;

    /**
     * 任务ID
     */
    private Long id;
    /**
     * 批处理任务ID
     */
    private Long taskId;
    /**
     * 素材ID
     */
    private String mediaId;

    /**
     *  素材标题
     */
    private String mediaName;

    /**
     * 素材类型  {@link MaterialTypeEnum}
     */
    private Integer mediaType;

    /**
     * 1:立即群发，2：定时群发
     */
    private Integer sendType;

    /**
     * '任务状态' 待开始,取消,任务失败,进行中,任务完成状态
     */
    private Integer taskStatue;

    /**
     * '发送时间'
     */
    private Date sendTime;

    /**
     * 群发完成时间
     */
    private Date successTime;

    /**
     * 群发范围 1:全部，2:定向
     */
    private Integer sendRange;

    /**
     * 用户限制 1. 全部用户 2:仅零售户
     */
    private Integer userLimit;

    /**
     * '地区限制'
     */
    private String province;

    private String city;

    private String district;

    /**
     * 标签ID
     */
    private List<Long> tags;

    /**
     * 客户群配置
     */
    private Long customerGroupId;

    /**
     * 测试人员
     */
    private String testUser;

    /**
     * 错误信息
     */
    private String errorDesc;

    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 主任成功，失败，过滤数目
     */
    private Long successCount;
    private Long errorCount;
    private Long filterCount;
}
