package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.dto.qrcode.WechatQrcodeExtraDTO;
import cn.com.duiba.wechat.server.api.enums.LogoTypeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/12 20:26
 */
@Getter
@Setter
public class RemoteQrcodeUpdateParam implements Serializable {

    /**
     * 二维码ID
     */
    @NotNull(message = "二维码id不能为空")
    private Long id;

    /**
     * 场景名称
     */
    @NotBlank(message = "场景名称不能为空")
    private String name;

    /**
     * logo url
     */
    private String logo;

    /**
     * logo类型, 0 无logo, 1 使用公众号头像, 2 自定义图片，默认 0
     *
     * @see LogoTypeEnum
     */
    private Integer logoType;

    /**
     * 是否开启扫码粉丝打标， 默认false
     */
    private Boolean mark;

    /**
     * 是否开启扫码后自动回复， 默认false
     */
    private Boolean autoResp;

    /**
     * 扩展信息，包含打标 list, 回复内容list
     */
    private WechatQrcodeExtraDTO extra;
}
