package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.enums.QrcodeStateEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/13 16:58
 */
@Getter
@Setter
public class RemoteQrcodeUpdateStateParam implements Serializable {

    /**
     * 二维码ID
     */
    @NotNull(message = "二维码ID不能为空")
    private Long id;

    /**
     * 类型
     * @see QrcodeStateEnum#DISABLE
     * @see QrcodeStateEnum#ENABLE
     */
    @NotNull(message = "类型不能为空")
    @Max(value = 1)
    @Min(value = 0)
    private Integer state;
}
